/*
 * Decompiled with CFR 0.152.
 */
package kski;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import kski.ColorLabelB;
import kski.ColorLabelC;

public class MulticolorSpritesDialog
extends JDialog {
    public static final long serialVersionUID = 0L;
    public int selectedColor;
    private static MulticolorSpritesDialog dialog = null;
    Vector<JLabel> labels = new Vector();
    Vector<ColorLabelC> labelsC = new Vector();
    static String lastFolder = null;
    JLabel pathLabel;
    ColorLabelB[] labelsOnLeft = new ColorLabelB[128];
    ColorLabelC[] labelsOnRight = new ColorLabelC[128];
    public static int[][] atariColors;

    static {
        int[][] nArrayArray = new int[128][];
        nArrayArray[0] = new int[3];
        nArrayArray[1] = new int[]{37, 37, 37};
        nArrayArray[2] = new int[]{70, 70, 70};
        nArrayArray[3] = new int[]{107, 107, 107};
        nArrayArray[4] = new int[]{131, 131, 131};
        nArrayArray[5] = new int[]{168, 168, 168};
        nArrayArray[6] = new int[]{202, 202, 202};
        nArrayArray[7] = new int[]{238, 238, 238};
        int[] nArray = new int[3];
        nArray[0] = 63;
        nArrayArray[8] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 99;
        nArray2[1] = 24;
        nArrayArray[9] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 133;
        nArray3[1] = 58;
        nArrayArray[10] = nArray3;
        nArrayArray[11] = new int[]{169, 94, 6};
        nArrayArray[12] = new int[]{194, 119, 31};
        nArrayArray[13] = new int[]{231, 156, 68};
        nArrayArray[14] = new int[]{255, 189, 101};
        nArrayArray[15] = new int[]{255, 226, 138};
        int[] nArray4 = new int[3];
        nArray4[0] = 80;
        nArrayArray[16] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 117;
        nArray5[1] = 5;
        nArrayArray[17] = nArray5;
        nArrayArray[18] = new int[]{150, 39, 22};
        nArrayArray[19] = new int[]{187, 75, 59};
        nArrayArray[20] = new int[]{211, 100, 84};
        nArrayArray[21] = new int[]{248, 137, 120};
        nArrayArray[22] = new int[]{255, 170, 154};
        nArrayArray[23] = new int[]{255, 207, 191};
        int[] nArray6 = new int[3];
        nArray6[0] = 84;
        nArray6[2] = 3;
        nArrayArray[24] = nArray6;
        int[] nArray7 = new int[3];
        nArray7[0] = 121;
        nArray7[2] = 39;
        nArrayArray[25] = nArray7;
        nArrayArray[26] = new int[]{154, 27, 73};
        nArrayArray[27] = new int[]{191, 63, 109};
        nArrayArray[28] = new int[]{216, 88, 134};
        nArrayArray[29] = new int[]{252, 125, 171};
        nArrayArray[30] = new int[]{255, 158, 204};
        nArrayArray[31] = new int[]{255, 195, 241};
        int[] nArray8 = new int[3];
        nArray8[0] = 79;
        nArray8[2] = 53;
        nArrayArray[32] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[0] = 116;
        nArray9[2] = 89;
        nArrayArray[33] = nArray9;
        nArrayArray[34] = new int[]{149, 20, 123};
        nArrayArray[35] = new int[]{186, 56, 159};
        nArrayArray[36] = new int[]{210, 81, 184};
        nArrayArray[37] = new int[]{247, 118, 221};
        nArrayArray[38] = new int[]{255, 151, 254};
        nArrayArray[39] = new int[]{255, 188, 255};
        int[] nArray10 = new int[3];
        nArray10[0] = 61;
        nArray10[2] = 104;
        nArrayArray[40] = nArray10;
        int[] nArray11 = new int[3];
        nArray11[0] = 97;
        nArray11[2] = 141;
        nArrayArray[41] = nArray11;
        nArrayArray[42] = new int[]{131, 19, 174};
        nArrayArray[43] = new int[]{167, 56, 211};
        nArrayArray[44] = new int[]{192, 80, 236};
        nArrayArray[45] = new int[]{229, 117, 255};
        nArrayArray[46] = new int[]{255, 150, 255};
        nArrayArray[47] = new int[]{255, 187, 255};
        int[] nArray12 = new int[3];
        nArray12[0] = 32;
        nArray12[2] = 139;
        nArrayArray[48] = nArray12;
        int[] nArray13 = new int[3];
        nArray13[0] = 69;
        nArray13[2] = 175;
        nArrayArray[49] = nArray13;
        nArrayArray[50] = new int[]{102, 27, 209};
        nArrayArray[51] = new int[]{139, 63, 246};
        nArrayArray[52] = new int[]{164, 88, 255};
        nArrayArray[53] = new int[]{200, 125, 255};
        nArrayArray[54] = new int[]{234, 158, 255};
        nArrayArray[55] = new int[]{255, 195, 255};
        int[] nArray14 = new int[3];
        nArray14[2] = 137;
        nArrayArray[56] = nArray14;
        nArrayArray[57] = new int[]{2, 28, 173};
        nArrayArray[58] = new int[]{35, 61, 207};
        nArrayArray[59] = new int[]{72, 98, 243};
        nArrayArray[60] = new int[]{97, 123, 255};
        nArrayArray[61] = new int[]{133, 159, 255};
        nArrayArray[62] = new int[]{167, 193, 255};
        nArrayArray[63] = new int[]{203, 229, 255};
        int[] nArray15 = new int[3];
        nArray15[1] = 12;
        nArray15[2] = 101;
        nArrayArray[64] = nArray15;
        int[] nArray16 = new int[3];
        nArray16[1] = 49;
        nArray16[2] = 137;
        nArrayArray[65] = nArray16;
        nArrayArray[66] = new int[]{7, 83, 171};
        nArrayArray[67] = new int[]{44, 119, 207};
        nArrayArray[68] = new int[]{69, 144, 232};
        nArrayArray[69] = new int[]{105, 180, 255};
        nArrayArray[70] = new int[]{139, 214, 255};
        nArrayArray[71] = new int[]{176, 251, 255};
        int[] nArray17 = new int[3];
        nArray17[1] = 31;
        nArray17[2] = 48;
        nArrayArray[72] = nArray17;
        int[] nArray18 = new int[3];
        nArray18[1] = 68;
        nArray18[2] = 84;
        nArrayArray[73] = nArray18;
        int[] nArray19 = new int[3];
        nArray19[1] = 102;
        nArray19[2] = 118;
        nArrayArray[74] = nArray19;
        nArrayArray[75] = new int[]{27, 138, 154};
        nArrayArray[76] = new int[]{52, 163, 179};
        nArrayArray[77] = new int[]{88, 200, 216};
        nArrayArray[78] = new int[]{122, 233, 249};
        nArrayArray[79] = new int[]{158, 255, 255};
        int[] nArray20 = new int[3];
        nArray20[1] = 43;
        nArrayArray[80] = nArray20;
        int[] nArray21 = new int[3];
        nArray21[1] = 80;
        nArray21[2] = 34;
        nArrayArray[81] = nArray21;
        int[] nArray22 = new int[3];
        nArray22[1] = 113;
        nArray22[2] = 68;
        nArrayArray[82] = nArray22;
        nArrayArray[83] = new int[]{23, 150, 104};
        nArrayArray[84] = new int[]{47, 175, 129};
        nArrayArray[85] = new int[]{84, 211, 165};
        nArrayArray[86] = new int[]{118, 245, 199};
        nArrayArray[87] = new int[]{154, 255, 236};
        int[] nArray23 = new int[3];
        nArray23[1] = 51;
        nArrayArray[88] = nArray23;
        int[] nArray24 = new int[3];
        nArray24[1] = 88;
        nArrayArray[89] = nArray24;
        int[] nArray25 = new int[3];
        nArray25[0] = 9;
        nArray25[1] = 121;
        nArrayArray[90] = nArray25;
        nArrayArray[91] = new int[]{46, 158, 2};
        nArrayArray[92] = new int[]{71, 183, 27};
        nArrayArray[93] = new int[]{107, 219, 64};
        nArrayArray[94] = new int[]{141, 253, 97};
        nArrayArray[95] = new int[]{178, 255, 134};
        int[] nArray26 = new int[3];
        nArray26[1] = 43;
        nArrayArray[96] = nArray26;
        int[] nArray27 = new int[3];
        nArray27[0] = 4;
        nArray27[1] = 80;
        nArrayArray[97] = nArray27;
        int[] nArray28 = new int[3];
        nArray28[0] = 38;
        nArray28[1] = 114;
        nArrayArray[98] = nArray28;
        int[] nArray29 = new int[3];
        nArray29[0] = 74;
        nArray29[1] = 150;
        nArrayArray[99] = nArray29;
        int[] nArray30 = new int[3];
        nArray30[0] = 99;
        nArray30[1] = 175;
        nArrayArray[100] = nArray30;
        nArrayArray[101] = new int[]{136, 211, 29};
        nArrayArray[102] = new int[]{169, 245, 63};
        nArrayArray[103] = new int[]{206, 255, 99};
        int[] nArray31 = new int[3];
        nArray31[0] = 1;
        nArray31[1] = 28;
        nArrayArray[104] = nArray31;
        int[] nArray32 = new int[3];
        nArray32[0] = 38;
        nArray32[1] = 65;
        nArrayArray[105] = nArray32;
        int[] nArray33 = new int[3];
        nArray33[0] = 72;
        nArray33[1] = 99;
        nArrayArray[106] = nArray33;
        int[] nArray34 = new int[3];
        nArray34[0] = 108;
        nArray34[1] = 135;
        nArrayArray[107] = nArray34;
        int[] nArray35 = new int[3];
        nArray35[0] = 133;
        nArray35[1] = 160;
        nArrayArray[108] = nArray35;
        nArrayArray[109] = new int[]{170, 196, 18};
        nArrayArray[110] = new int[]{203, 230, 51};
        nArrayArray[111] = new int[]{240, 255, 88};
        int[] nArray36 = new int[3];
        nArray36[0] = 35;
        nArray36[1] = 9;
        nArrayArray[112] = nArray36;
        int[] nArray37 = new int[3];
        nArray37[0] = 72;
        nArray37[1] = 45;
        nArrayArray[113] = nArray37;
        int[] nArray38 = new int[3];
        nArray38[0] = 105;
        nArray38[1] = 79;
        nArrayArray[114] = nArray38;
        int[] nArray39 = new int[3];
        nArray39[0] = 142;
        nArray39[1] = 115;
        nArrayArray[115] = nArray39;
        int[] nArray40 = new int[3];
        nArray40[0] = 166;
        nArray40[1] = 140;
        nArrayArray[116] = nArray40;
        nArrayArray[117] = new int[]{203, 177, 31};
        nArrayArray[118] = new int[]{237, 210, 65};
        nArrayArray[119] = new int[]{255, 247, 101};
        int[] nArray41 = new int[3];
        nArray41[0] = 63;
        nArrayArray[120] = nArray41;
        int[] nArray42 = new int[3];
        nArray42[0] = 99;
        nArray42[1] = 24;
        nArrayArray[121] = nArray42;
        int[] nArray43 = new int[3];
        nArray43[0] = 133;
        nArray43[1] = 58;
        nArrayArray[122] = nArray43;
        nArrayArray[123] = new int[]{169, 94, 6};
        nArrayArray[124] = new int[]{194, 119, 31};
        nArrayArray[125] = new int[]{231, 156, 68};
        nArrayArray[126] = new int[]{255, 189, 101};
        nArrayArray[127] = new int[]{255, 226, 138};
        atariColors = nArrayArray;
    }

    public static String findAtariColorCode(Color color) {
        int i = 0;
        while (i < atariColors.length) {
            Color c = MulticolorSpritesDialog.getAtariColorRGB(i);
            if (c.equals(color)) {
                return MulticolorSpritesDialog.toHex(i * 2, 2);
            }
            ++i;
        }
        return "";
    }

    public static int findAtariColorIndex(Color color) {
        int i = 0;
        while (i < atariColors.length) {
            Color c = MulticolorSpritesDialog.getAtariColorRGB(i);
            if (c.equals(color)) {
                return i * 2;
            }
            ++i;
        }
        return -1;
    }

    public static int selectColor() {
        if (dialog == null) {
            dialog = new MulticolorSpritesDialog();
            dialog.setSize(1024, 600);
            MulticolorSpritesDialog.centerWindow(dialog);
        }
        MulticolorSpritesDialog.dialog.selectedColor = 0;
        dialog.setVisible(true);
        return MulticolorSpritesDialog.dialog.selectedColor;
    }

    private MulticolorSpritesDialog() {
        super((Dialog)null, "Multicolor sprite 3'rd color. Kski 2021", true);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel();
        JButton button = new JButton("Select palette file");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MulticolorSpritesDialog.this.selectPaletteFile();
            }
        });
        buttonsPanel.add(button);
        this.pathLabel = new JLabel("");
        buttonsPanel.add(this.pathLabel);
        this.getContentPane().add((Component)buttonsPanel, "North");
        JPanel colorsPanel = new JPanel(new GridLayout(atariColors.length / 8, 9));
        int row = 0;
        while (row < 16) {
            int i = 0;
            while (i < 8) {
                ColorLabelB label = new ColorLabelB(this, row * 8 + i);
                label.setBackground(MulticolorSpritesDialog.getAtariColorRGB(row * 8 + i));
                colorsPanel.add(label);
                this.labelsOnLeft[row * 8 + i] = label;
                ++i;
            }
            JLabel l = new JLabel("  "){

                @Override
                public void setBackground(Color color) {
                    super.setBackground(color);
                    if (color == null) {
                        this.setForeground(Color.black);
                    } else {
                        int i = (color.getRed() + color.getBlue() + color.getGreen()) / 3;
                        if (i > 128) {
                            this.setForeground(Color.black);
                        } else {
                            this.setForeground(Color.white);
                        }
                    }
                }
            };
            colorsPanel.add(l);
            this.labels.add(l);
            int i2 = 0;
            while (i2 < 8) {
                JPanel panel = new JPanel(new GridLayout(1, 2));
                ColorLabelC label1 = new ColorLabelC(this, row * 8 + i2);
                label1.setBackground(MulticolorSpritesDialog.getAtariColorRGB(row * 8 + i2));
                ColorLabelC label2 = new ColorLabelC(this, row * 8 + i2);
                label2.setBackground(MulticolorSpritesDialog.getAtariColorRGB(row * 8 + i2));
                panel.add(label1);
                panel.add(label2);
                panel.setBorder(BorderFactory.createLineBorder(Color.black));
                this.labelsC.add(label2);
                colorsPanel.add(panel);
                this.labelsOnRight[row * 8 + i2] = label1;
                ++i2;
            }
            ++row;
        }
        this.selectedColor = 0;
        this.getContentPane().add((Component)colorsPanel, "Center");
    }

    public void selectPaletteFile() {
        FileDialog dialog = new FileDialog((Dialog)this, "Open palette file", 0);
        dialog.setFile("*.*");
        dialog.setDirectory(lastFolder);
        dialog.setVisible(true);
        if (dialog.getFile() == null) {
            return;
        }
        lastFolder = dialog.getDirectory();
        String path = String.valueOf(lastFolder) + dialog.getFile();
        File file = new File(path);
        try {
            byte[] bytes = MulticolorSpritesDialog.loadFile(file);
            if (bytes == null || bytes.length != 768) {
                JOptionPane.showMessageDialog(this, "Error loading file " + path + "\n768 bytes file expected", "Error", 0);
            }
            this.pathLabel.setText(path);
            int i = 0;
            while (i < 128) {
                int r = bytes[i * 6] & 0xFF;
                int g = bytes[i * 6 + 1] & 0xFF;
                int b = bytes[i * 6 + 2] & 0xFF;
                MulticolorSpritesDialog.atariColors[i][0] = r;
                MulticolorSpritesDialog.atariColors[i][1] = g;
                MulticolorSpritesDialog.atariColors[i][2] = b;
                this.labelsOnLeft[i].setBackground(MulticolorSpritesDialog.getAtariColorRGB(i));
                this.labelsOnRight[i].setBackground(MulticolorSpritesDialog.getAtariColorRGB(i));
                this.repaint();
                ++i;
            }
            this.colorSelected(this.selectedColor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error loading file: " + ex.getClass().getSimpleName() + ": " + ex.getMessage(), "Error", 0);
        }
    }

    public static byte[] loadFile(final File file) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    if (!file.exists() || !file.isFile()) {
                        throw new Exception("File " + file.getPath() + " not found!");
                    }
                    FileInputStream fis = new FileInputStream(file);
                    int toRead = (int)file.length();
                    byte[] bytes = new byte[toRead];
                    int index = 0;
                    while (toRead > 0) {
                        int read = fis.read(bytes, index, toRead);
                        toRead -= read;
                        index += read;
                    }
                    fis.close();
                    return bytes;
                }
            });
        }
        catch (PrivilegedActionException pex) {
            Exception x = pex.getException();
            if (x instanceof Exception) {
                throw x;
            }
            throw new Exception(x.getMessage(), x);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            System.exit(0);
        }
    }

    public void colorSelected(int index) {
        this.selectedColor = index;
        for (JLabel label : this.labels) {
            label.setOpaque(true);
            label.setBackground(MulticolorSpritesDialog.getAtariColorRGB(index));
            label.setText(MulticolorSpritesDialog.toHex(index * 2, 2));
            label.doLayout();
        }
        int i = 0;
        while (i < 128) {
            int thirdColor = index | i;
            this.labelsC.get(i).setBackground(MulticolorSpritesDialog.getAtariColorRGB(thirdColor));
            this.labelsC.get(i).setText(MulticolorSpritesDialog.toHex(thirdColor * 2, 2));
            ++i;
        }
    }

    public static Color getAtariColorRGB(int i) {
        return new Color(atariColors[i][0], atariColors[i][1], atariColors[i][2]);
    }

    public static void centerWindow(Component comp) {
        int yPos;
        int xPos;
        Container parent = comp.getParent();
        if (parent != null && parent.isVisible()) {
            xPos = parent.getX() + (parent.getWidth() - comp.getWidth()) / 2;
            yPos = parent.getY() + (parent.getHeight() - comp.getHeight()) / 2;
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            xPos = (screenSize.width - comp.getWidth()) / 2;
            yPos = (screenSize.height - comp.getHeight()) / 2;
        }
        if (xPos < 0) {
            xPos = 0;
        }
        if (yPos < 0) {
            yPos = 0;
        }
        comp.setLocation(xPos, yPos);
    }

    public static String colorToHex(Color color) {
        if (color != null) {
            return String.valueOf(MulticolorSpritesDialog.toHex(color.getRed(), 2)) + MulticolorSpritesDialog.toHex(color.getGreen(), 2) + MulticolorSpritesDialog.toHex(color.getBlue(), 2);
        }
        return null;
    }

    public static String toHex(Integer number, int digits) {
        if (number == null) {
            return "??";
        }
        String s = Integer.toHexString(number).toUpperCase();
        while (s.length() < digits) {
            s = "0" + s;
        }
        return s;
    }
}

